 ; Ŀ
 ;   Ze - Zoom Extents with (usually) no regen.                            
 ;   Copyright 1990, 2001, 2003, 2010 by Rocket Software Ltd.              
 ;   When don't seconds count?                                             
 ; 

 ; Ŀ
 ;   Vprt - see if we are in model space, paper space, or a viewport.      
 ;   Returns a list: a descriptive string: model, paper, or vport          
 ;   and the corner points of either the current screen, if we are in      
 ;   paper or model space, or the corners of the current vport in overall  
 ;   screen coordinates, not those of the viewport itself.                 
 ;   Calls nothing, takes no arguments.                                    
 ; 
 (DEFUN VPRT (/ cvport spac a vs ctr w cornr1 cornr2 cornrs)
  (setq cvport (getvar "cvport"))
 ; Ŀ
 ;   Possibilities: we are in the model tab.                               
 ; 
  (cond ((= (getvar "ctab") "Model")
         (setq spac "Model")
         (setq a (getvar "screensize"))        ; view height & width (pixels)
         (setq a (/ (car a) (cadr a)))         ; view width/height ratio
         (setq vs (* (getvar "viewsize") 0.5)) ; view height in drawing units
         (setq ctr (getvar "viewctr"))         ; centre point of screen
         (setq w (* vs a ))                    ; view half width
         (setq cornr1 (list (- (car ctr) w) (- (cadr ctr) vs)))
         (setq cornr2 (list (+ (car ctr) w) (+ (cadr ctr) vs))))
 ; Ŀ
 ;   In any layout (ps) tab, paper space is always viewport number 1.      
 ; 
        ((= 1 cvport)
         (setq spac "Paper"))
 ; Ŀ
 ;   The default: We are in a viewport in paper space.                     
 ; 
        (t
         (setq spac "Vport")))
 ; Ŀ
 ;   If we are in paper space or a viewport, get the corners.              
 ; 
  (if (= spac "Model")
      (setq cornrs (list cornr1 cornr2))
      (setq cornrs (cdr (assoc cvport (vports)))))
 (list spac cornrs))
 ; Ŀ
 ;   Vprt end.                                                             
 ; 

 ; Ŀ
 ;   Ze.                                                                   
 ; 
 (DEFUN C:ZE ( / a b *error*)
  (setvar "cmdecho" 0)
  (DEFUN *ERROR* (shk)
   (if (= shk "invalid point")
       (progn
            (write-line "*Error* - Extents may be invalid.  Values are:")
            (prin1 (list a b)))
       (write-line (strcat "\n" shk)))
  (princ))
  (if (= (car (vprt)) "Vport")
      (command "pspace"))
  (command "zoom" "e")
  (setq a (getvar "extmin"))
  (setq b (getvar "extmax"))
  (command "zoom" "w" a b)
 (princ))